﻿$(document).ready(function () {
    var context = $(".folder-properties");

    $(".h-themesAutocomplete", context).a4autocomplete({
        ajaxAction: a4.getAction("GetThemesForAutoComplete", "LookAndFeel", "Survey"),
        valueProperty: "Id",
        labelProperty: "Name",
        categoryProperty: "Category",
        tooltipData: function (autocomplete, tooltip, data) {
            if (tooltip && data) {
                GetThemePreviewImage(data.Id, data.Public, function (image) {
                    tooltip.html(image).show();
                });
            }
        },
        select: function (event, data) {
            if (data.item) {
                $("#DefaultThemeId").val(data.item.Id);
                $("#PublicDefaultTheme").val(data.item.Public);
                $(".v-defaultThemePreview").html("").show();
                GetThemePreviewImage(data.item.Id, data.item.Public, function (image) {
                    $(".v-defaultThemePreview").html(image);
                });
            }
            else {
                $("#DefaultThemeId").val("");
                $("#PublicDefaultTheme").val(false);
                $(".v-defaultThemePreview").hide();
            }
        }
    });
});

function GetThemePreviewImage(themeId, publicTheme, callback) {
    a4.callServerMethod(a4.getAction("GetSelectedThemeItemThumbnail", "LookAndFeel", "Survey"), { themeId: themeId, publicTheme: publicTheme, surveyId: 0 },
    function (result) {
        if (result && callback) {
            callback($("<img />", { src: result }));
        }
    });
}